﻿//////////////////////////////////////////////
// InputCodes.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Enums ------------------------------------

namespace nkWinUi
{
	enum class MOUSE_BUTTON
	{
		MOUSE_LEFT = 0x0001,
		MOUSE_MIDDLE = 0x0010,
		MOUSE_RIGHT = 0x0002,
		MOUSE_X1 = 0x0020,
		MOUSE_X2 = 0x0040
	} ;

	enum class KEY_CODE
	{
		// UNKNOWN
		KEY_UNKNOWN = 0,
		// Microsoft
		KEY_BACKSPACE = 0x08,
		KEY_TAB,
		// ...
		// Some unassigned enum values from MS
		// ...
		KEY_CLEAR = 0x0C,
		KEY_RETURN,
		// ...
		// Some unassigned enum values from MS
		// ...
		KEY_SHIFT = 0x10,
		KEY_CONTROL,
		KEY_MENU,
		KEY_PAUSE,
		KEY_CAPITAL,
		KEY_KANA,
		// ...
		// Language extended keys
		// ...
		KEY_KANJI = 0x19,
		// ...
		// Some unassigned enum values from MS
		// ...
		KEY_ESCAPE = 0x1B,
		// ...
		// IME keys
		// ...
		KEY_SPACE = 0x20,
		KEY_UP_PAGE,
		KEY_DOWN_PAGE,
		KEY_END,
		KEY_HOME,
		KEY_LEFT,
		KEY_UP,
		KEY_RIGHT,
		KEY_DOWN,
		KEY_SELECT,
		KEY_PRINT,
		KEY_EXEC,
		KEY_PRINT_SCREEN,
		KEY_INSERT,
		KEY_DEL,
		KEY_HELP,
		KEY_0,
		KEY_1,
		KEY_2,
		KEY_3,
		KEY_4,
		KEY_5,
		KEY_6,
		KEY_7,
		KEY_8,
		KEY_9,
		// ...
		// Some unassigned enum values from MS
		// ...
		KEY_A = 0x41,
		KEY_B,
		KEY_C,
		KEY_D,
		KEY_E,
		KEY_F,
		KEY_G,
		KEY_H,
		KEY_I,
		KEY_J,
		KEY_K,
		KEY_L,
		KEY_M,
		KEY_N,
		KEY_O,
		KEY_P,
		KEY_Q,
		KEY_R,
		KEY_S,
		KEY_T,
		KEY_U,
		KEY_V,
		KEY_W,
		KEY_X,
		KEY_Y,
		KEY_Z,
		KEY_LEFT_WINDOWS,
		KEY_RIGHT_WINDOWS,
		KEY_APPS,
		// ...
		// Some unassigned enum values from MS
		// ...
		KEY_SLEEP = 0x5F,
		KEY_0_NUMPAD,
		KEY_1_NUMPAD,
		KEY_2_NUMPAD,
		KEY_3_NUMPAD,
		KEY_4_NUMPAD,
		KEY_5_NUMPAD,
		KEY_6_NUMPAD,
		KEY_7_NUMPAD,
		KEY_8_NUMPAD,
		KEY_9_NUMPAD,
		KEY_MULT,
		KEY_ADD,
		KEY_SEPARATOR,
		KEY_SUBSTRACT,
		KEY_DECIMAL,
		KEY_DIVIDE,
		KEY_F1
	} ;
}